using UnityEngine;

public class LocationTracker : MonoBehaviour
{
    [SerializeField] private Camera arCamera;

    public Vector3 CurrentLocation => arCamera.transform.position;

    public bool IsNodeReached(Vector3 nodePosition, float threshold = 0.5f)
    {
        return Vector2.Distance(new Vector2(arCamera.transform.position.x, arCamera.transform.position.z), new Vector2(nodePosition.x, nodePosition.z)) <= threshold;
        // return Vector3.Distance(CurrentLocation, nodePosition) <= threshold;
    }
}
